<?php

define("IN_SITE", true);

require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");
//require_once (__DIR__.'/../../models/is_user.php');





$CMSNT = new DB();
$data = [];
$i=0;
foreach ($CMSNT->get_list_safe("SELECT * FROM `products` WHERE `status` = 1") as $row) {
    $product_id = validate_int($row['id'], 1);
    if ($product_id !== false) {
        $available_count = $CMSNT->num_rows_safe("SELECT * FROM `accounts` WHERE `product_id` = ? AND `buyer` IS NULL AND `status` = 'LIVE'", [$product_id]);
        
        $data[] = [
            'name'      => '<b style="font-size: 14px;">'.htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8').'</b> <span class="text-muted fw-bold text-muted d-block fs-7">'.htmlspecialchars($row['content'], ENT_QUOTES, 'UTF-8').'</span>',
            'flag'      => display_flag($row['flag']),
            'soluong'   => format_cash($available_count),
            'price'     => format_currency($row['price']),
            'action'    => '<button type="button" onclick="modalBuy('.htmlspecialchars($row['id'], ENT_QUOTES, 'UTF-8').', '.htmlspecialchars($row['price'], ENT_QUOTES, 'UTF-8').')" class="btn btn-primary btn-sm px-4">Mua</button>'
        ];
    }
}
echo json_encode(['data' => $data], JSON_PRETTY_PRINT);
exit();
