<?php

define("IN_SITE", true);

require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");
require_once(__DIR__."/../../libs/lang.php");
use PragmaRX\Google2FA\Google2FA;

$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($CMSNT->site('status') != 1 && isSecureCookie('admin_login') != true) {
        die(json_encode(['status' => 'error', 'msg' => __('Hệ thống đang bảo trì')]));
    }
    $username = validate_alphanumeric($_POST['username'], 50);
    if ($username === false) {
        die(json_encode(['status' => 'error', 'msg' => __('Username không hợp lệ (3-50 ký tự, chỉ chữ, số, _, -)')]));
    }
    $email = validate_email($_POST['email']);
    if ($email === false) {
        die(json_encode(['status' => 'error', 'msg' => __('Email không hợp lệ')]));
    }
    $password = validate_string($_POST['password'], 255, 5);
    if ($password === false) {
        die(json_encode(['status' => 'error', 'msg' => __('Mật khẩu không hợp lệ (tối thiểu 5 ký tự)')]));
    }
    $repassword = validate_string($_POST['repassword'], 255, 5);
    if ($repassword === false) {
        die(json_encode(['status' => 'error', 'msg' => __('Nhập lại mật khẩu không hợp lệ')]));
    }
    if ($password != $repassword) {
        die(json_encode(['status' => 'error', 'msg' => __('Nhập lại mật khẩu không đúng')]));
    }
    if($CMSNT->site('reCAPTCHA_status') == 1){
        if (empty($_POST['recaptcha'])) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng xác minh Captcha')]));
        }
        $recaptcha = check_string($_POST['recaptcha']);
        $url = "https://www.google.com/recaptcha/api/siteverify?secret=".$CMSNT->site('reCAPTCHA_secret_key')."&response=$recaptcha";
        $verify = file_get_contents($url);
        $captcha_success=json_decode($verify);
        if ($captcha_success->success==false) {
            die(json_encode(['status' => 'error', 'msg' => __('Vui lòng xác minh Captcha')]));
        }
    }
    if ($CMSNT->get_row_safe("SELECT * FROM `users` WHERE `username` = ? ", [$username])) {
        die(json_encode(['status' => 'error','msg' => __('Tên đăng nhập đã tồn tại trong hệ thống')]));
    }
    if ($CMSNT->get_row_safe("SELECT * FROM `users` WHERE `email` = ? ", [$email])) {
        die(json_encode(['status' => 'error', 'msg' => __('Địa chỉ email đã tồn tại trong hệ thống')]));
    }
    $user_ip = validate_ip(myip());
    if ($user_ip !== false) {
        if ($CMSNT->num_rows_safe("SELECT * FROM `users` WHERE `ip` = ? ", [$user_ip]) >= $CMSNT->site('max_register_ip')) {
            die(json_encode(['status' => 'error', 'msg' => __('IP của bạn đã đạt giới hạn tạo tài khoản cho phép')]));
        }
    }
    # Create the 2FA class
    $google2fa = new Google2FA();
    $token = generateUltraSecureToken().$username;
    $isCreate = $CMSNT->insert("users", [
        'token'         => $token,
        'username'      => $username,
        'email'         => $email,
        'password'      => TypePassword($password),
        'ref_id'        => !empty($_SESSION['ref']) ? (validate_int($_SESSION['ref'], 1) ?: 0) : 0,
        'ip'            => $user_ip ?: myip(),
        'device'        => $Mobile_Detect->getUserAgent(),
        'create_date'   => gettime(),
        'update_date'   => gettime(),
        'time_session'  => time(),
        'change_password'        => 1,
        'SecretKey_2fa' => $google2fa->generateSecretKey()
    ]);
    if ($isCreate) {
        $new_user = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? ", [$token]);
        $CMSNT->insert("logs", [
            'user_id'       => $new_user['id'],
            'ip'            => $user_ip ?: myip(),
            'device'        => $Mobile_Detect->getUserAgent(),
            'createdate'    => gettime(),
            'action'        => __('Thực hiện tạo tài khoản')
        ]);


        // Lưu đăng nhập vào Cookie
        setSecureCookie('user_login', $token);
        setSecureCookie('user_agent', $Mobile_Detect->getUserAgent());

        /** SEND NOTI CHO ADMIN */
        $my_text = $CMSNT->site('register_notification');
        $my_text = str_replace('{domain}', $_SERVER['SERVER_NAME'], $my_text);
        $my_text = str_replace('{username}', $username, $my_text);
        $my_text = str_replace('{email}', $email, $my_text);
        $my_text = str_replace('{ip}', $user_ip ?: myip(), $my_text);
        $my_text = str_replace('{device}', $Mobile_Detect->getUserAgent(), $my_text);
        $my_text = str_replace('{time}', gettime(), $my_text);
        sendMessAdmin($my_text);
        die(json_encode(['status' => 'success', 'msg' => __('Đăng ký thành công')]));
    } else {
        die(json_encode(['status' => 'error', 'msg' => __('Tạo tài khoản thất bại, vui lòng thử lại')]));
    }
}
