<?php

define("IN_SITE", true);
require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");
require_once(__DIR__."/../../libs/sendEmail.php");
require_once(__DIR__."/../../libs/database/users.php");
$User = new users();
$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($CMSNT->site('status') != 1 && isSecureCookie('admin_login') != true) {
        die(json_encode(['status' => 'error', 'msg' => 'Hệ thống đang bảo trì.']));
    }
    // Validate input với validation functions
    $service_id = validate_int($_POST['id'], 1);
    if ($service_id === false) {
        die(json_encode(['status' => 'error', 'msg' => 'ID dịch vụ không hợp lệ.']));
    }
    
    $amount = validate_int($_POST['amount'], 1);
    if ($amount === false) {
        die(json_encode(['status' => 'error', 'msg' => 'Số lượng không hợp lệ.']));
    }
    
    $url = validate_url($_POST['url']);
    if ($url === false) {
        die(json_encode(['status' => 'error', 'msg' => 'URL không hợp lệ.']));
    }
    
    $token = validate_alphanumeric($_POST['token'], 100);
    if ($token === false) {
        die(json_encode(['status' => 'error', 'msg' => 'Token không hợp lệ.']));
    }
    
    if (!$getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ? AND `banned` = 0", [$token])) {
        die(json_encode(['status' => 'error', 'msg' => 'Vui lòng đăng nhập.']));
    }
    if (time() - $getUser['time_request'] < 2) {
        die(json_encode(['status' => 'error', 'msg' => 'Bạn đang thao tác quá nhanh, vui lòng chờ.']));
    }
    
    if (!$row = $CMSNT->get_row_safe("SELECT * FROM `services` WHERE `id` = ? AND `status` = 1", [$service_id])) {
        die(json_encode(['status' => 'error', 'msg' => 'Sản phẩm không tồn tại trong hệ thống.']));
    }
    $total_payment = $amount * $row['price'];
    if (getRowRealtime("users", $getUser['id'], "money") < $total_payment) {
        die(json_encode(['status' => 'error', 'msg' => 'Số dư không đủ, vui lòng nạp thêm.']));
    }
    $trans_id = random("QWETYUIOPASDFGHJKLXCVBNM", 4).time();
    $isBuy = $User->RemoveCredits($getUser['id'], $total_payment, "Thanh toán đơn hàng dịch vụ #".$trans_id);
    if ($isBuy) {
        if (getRowRealtime("users", $getUser['id'], "money") < 0) {
            $User->banned($getUser['id'], 'Gian lận khi order dịch vụ');
            die(json_encode(['status' => 'error', 'msg' => 'Bạn đã bị khoá tài khoản vì gian lận.']));
        }
        $isInsertOrder = $CMSNT->insert("service_order", [
            'trans_id'  => $trans_id,
            'seller'    => $row['user_id'],
            'buyer'     => $getUser['id'],
            'service_id'=> $row['id'],
            'url'       => $url,
            'amount'    => $amount,
            'pay'       => $total_payment,
            'create_date'=> gettime(),
            'update_date'=> gettime()
        ]);
        if ($isInsertOrder) {
            $guitoi = $CMSNT->site('email');
            $subject = 'Thông báo có đơn đặt hàng dịch vụ cần được xử lý';
            $bcc = $CMSNT->site('title');
            $hoten ='CMSNT BOT';
            $noi_dung = '<h2>Thông tin đơn hàng mới</h2>
            <table >
            <tbody>
            <tr>
            <td>Mã giao dịch:</td>
            <td><b>'.$trans_id.'</b></td>
            </tr>
            <tr>
            <td>Dịch vụ:</td>
            <td><b style="color:blue;">'.$row['name'].'</b></td>
            </tr>
            <tr>
            <td>Số lượng cần mua:</td>
            <td><b>'.format_cash($amount).'</b></td>
            </tr>
            <tr>
            <td>Liên kết cần tăng:</td>
            <td><b>'.htmlspecialchars($url, ENT_QUOTES, 'UTF-8').'</b></td>
            </tr>
            <tr>
            <td>Số tiền thanh toán</td>
            <td><b>'.format_currency($total_payment).'</b></td>
            </tr>
            <tr>
            <td>Thời gian thanh toán:</td>
            <td><b>'.gettime().'</b></td>
            </tr>
            <tr>
            <td>Khách hàng</td>
            <td><b style="color:red;">'.$getUser['username'].'</b></td>
            </tr>
            </tbody>
            </table>';
            sendCSM($guitoi, $hoten, $subject, $noi_dung, $bcc);
            die(json_encode(['status' => 'success', 'msg' => 'Thanh toán đơn hàng thành công.']));
        } else {
            $User->AddCredits($getUser['id'], $total_payment, "Hoàn tiền đơn hàng dịch vụ #".$trans_id);
            die(json_encode(['status' => 'error', 'msg' => 'Không thể thanh toán, vui lòng thử lại.']));
        }
    }
    die(json_encode(['status' => 'error', 'msg' => 'Không thể thanh toán, vui lòng thử lại.']));
} else {
    die('The Request Not Found');
}
