<?php
define("IN_SITE", true);
require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/lang.php");
require_once(__DIR__."/../../libs/helper.php");
$CMSNT = new DB();
if($CMSNT->site('sign_view_product') == 0){
    if (isset($_COOKIE['user_login'])) {
        require_once(__DIR__.'/../../models/is_user.php');
    }
}else{
    require_once(__DIR__.'/../../models/is_user.php');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {?>

<div class="row">
    <?php
    // Validate category_id input
    $category_id = validate_int($_POST['id'], 0);
    if ($category_id === false) {
        die(json_encode(['status' => 'error', 'msg' => 'ID danh mục không hợp lệ']));
    }
    
    if ($category_id == 0) {
        $listProduct = $CMSNT->get_list_safe("SELECT * FROM `documents` WHERE `status` = 1 ORDER BY `stt` ASC ");
    } else {
        $listProduct = $CMSNT->get_list_safe("SELECT * FROM `documents` WHERE `category_id` = ? AND `status` = 1 ORDER BY `stt` ASC ", [$category_id]);
    }
    if ($listProduct){ ?>

    <div class="table-responsive">
        <table class="table table-striped table-bordered mb-0">
            <thead class="table-color-heading">
                <tr>
                    <th><?=__('Danh sách TUT/Trick');?></th>
                    <th><?=__('Chuyên mục');?></th>
                    <th><?=__('Giá');?></th>
                    <th><?=__('Ngày đăng');?></th>
                    <th><?=__('Cập nhật');?></th>
                    <th><?=__('Thao tác');?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($listProduct as $product) {?>
                <tr>
                    <td width="40%"><img class="mr-1" src="<?=base_url(getRowRealtime("document_categories", $product['category_id'], 'image'));?>" width="25px"><?=__($product['name']);?></td>
                    <td><span class="badge badge-dark"><?=getRowRealtime("document_categories", $product['category_id'], 'name');?></span></td>
                    <td><b style="color: red;"><?=format_currency($product['price']);?></b></td>
                    <td><i><?=$product['create_date'];?></i></td>
                    <td><i><?=$product['update_date'];?></i></td>
                    <td>
                        <?php if (isset($_COOKIE['user_login'])):?>
                            <?php 
                            $user_id = validate_int($getUser['id'], 1);
                            $product_id = validate_int($product['id'], 1);
                            if ($user_id !== false && $product_id !== false) {
                                $existing_order = $CMSNT->get_row_safe("SELECT * FROM `orders` WHERE `buyer` = ? AND `document_id` = ?", [$user_id, $product_id]);
                            } else {
                                $existing_order = false;
                            }
                            ?>
                            <?php if($existing_order):?>
                                <a href="<?=base_url('client/order/'.htmlspecialchars($existing_order['trans_id'], ENT_QUOTES, 'UTF-8'));?>" class="btn btn-danger btn-sm"><i class="fa-solid fa-eye mr-1"></i><?=__('XEM');?></a>
                            <?php else:?>
                                <button onclick="modalBuy(<?=htmlspecialchars($product['id'], ENT_QUOTES, 'UTF-8');?>, <?=htmlspecialchars($product['price'], ENT_QUOTES, 'UTF-8');?>, `<?=htmlspecialchars(__($product['name']), ENT_QUOTES, 'UTF-8');?>`)" class="btn btn-primary btn-sm"><i class="fa-solid fa-cart-shopping mr-1"></i><?=__('MUA NGAY');?></button>
                            <?php endif?>
                        <?php else:?>
                            <button onclick="modalBuy(<?=htmlspecialchars($product['id'], ENT_QUOTES, 'UTF-8');?>, <?=htmlspecialchars($product['price'], ENT_QUOTES, 'UTF-8');?>, `<?=htmlspecialchars(__($product['name']), ENT_QUOTES, 'UTF-8');?>`)" class="btn btn-primary btn-sm"><i class="fa-solid fa-cart-shopping mr-1"></i><?=__('MUA NGAY');?></button>
                        <?php endif?>
                    </td>
                </tr>
                <?php }?>
            </tbody>
        </table>
    </div>


    <?php  } else {?>
    <div class="col-sm-12 text-center">
        <div class="iq-maintenance">
            <img src="<?=base_url('public/datum');?>/assets/images/error/maintenance.png" class="img-fluid" alt="">
            <h3 class="mt-4 mb-2"><?=__('Sản phẩm không tồn tại');?></h3>
        </div>
    </div>
    <?php }?>
</div>


<?php
}?>