<?php

define("IN_SITE", true);

require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");
require_once(__DIR__.'/../../models/is_ctv.php');

if (isset($_POST['id'])) {
    if ($CMSNT->site('status_demo') != 0) {
        $data = json_encode([
            'status'    => 'error',
            'msg'       => 'Không được dùng chức năng này vì đây là trang web demo'
        ]);
        die($data);
    }
    
    // Validate input ID
    $id = validate_int($_POST['id'], 1);
    if ($id === false) {
        $data = json_encode([
            'status'    => 'error',
            'msg'       => 'ID tài khoản không hợp lệ'
        ]);
        die($data);
    }
    
    // Validate user ID
    $user_id = validate_int($getUser['id'], 1);
    if ($user_id === false) {
        $data = json_encode([
            'status'    => 'error',
            'msg'       => 'Thông tin người dùng không hợp lệ'
        ]);
        die($data);
    }
    
    // Sử dụng prepared statement để kiểm tra tài khoản
    $row = $CMSNT->get_row_safe("SELECT * FROM `accounts` WHERE `id` = ? AND `seller` = ?", [$id, $user_id]);
    if (!$row) {
        $data = json_encode([
            'status'    => 'error',
            'msg'       => 'ID tài khoản không tồn tại trong hệ thống'
        ]);
        die($data);
    }
    
    // Sử dụng prepared statement để xóa tài khoản
    $isRemove = $CMSNT->remove("accounts", " `id` = ?", [$id]);
    if ($isRemove) {
        $Mobile_Detect = new Mobile_Detect();
        $CMSNT->insert("logs", [
            'user_id'       => $user_id,
            'ip'            => myip(),
            'device'        => $Mobile_Detect->getUserAgent(),
            'createdate'    => gettime(),
            'action'        => 'Xoá tài khoản ('.htmlspecialchars($row['account'], ENT_QUOTES, 'UTF-8').')'
        ]);
        $data = json_encode([
            'status'    => 'success',
            'msg'       => 'Xóa tài khoản thành công'
        ]);
        die($data);
    } else {
        $data = json_encode([
            'status'    => 'error',
            'msg'       => 'Không thể xóa tài khoản'
        ]);
        die($data);
    }
} else {
    $data = json_encode([
        'status'    => 'error',
        'msg'       => 'Dữ liệu không hợp lệ'
    ]);
    die($data);
}
