<?php

define("IN_SITE", true);

require_once(__DIR__."/../../libs/db.php");
require_once(__DIR__."/../../libs/helper.php");
require_once(__DIR__.'/../../models/is_ctv.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Validate trans_id input
    $trans_id = validate_alphanumeric($_POST['trans_id'], 100);
    if ($trans_id === false) {
        die('Trans ID không hợp lệ');
    }
    
    // Validate user ID để đảm bảo chỉ hiển thị tài khoản của user hiện tại
    $user_id = validate_int($getUser['id'], 1);
    if ($user_id === false) {
        die('Thông tin người dùng không hợp lệ');
    }
    
    // Sử dụng prepared statement để lấy danh sách tài khoản
    // Chỉ hiển thị tài khoản thuộc về user hiện tại thông qua bảng orders
    $accounts = $CMSNT->get_list_safe("
        SELECT a.* FROM `accounts` a 
        INNER JOIN `orders` o ON a.trans_id = o.trans_id 
        WHERE a.trans_id = ? AND o.seller = ? 
        ORDER BY a.id DESC
    ", [$trans_id, $user_id]);
    
    $data = '';
    foreach ($accounts as $taikhoan) {
        $data .= htmlspecialchars($taikhoan['account'], ENT_QUOTES, 'UTF-8').PHP_EOL;
    }
    die($data);
}
