<?php

if (!defined('IN_SITE')) {
    die('The Request Not Found');
}


$CMSNT = new DB();
$Mobile_Detect = new Mobile_Detect();

if (isSecureCookie('user_login') != true) { 
    redirect(base_url('client/logout'));
} else {
    // Validate và sử dụng prepared statement an toàn
    $user_token = validate_alphanumeric($_COOKIE['user_login'], 255);
    if ($user_token === false) {
        redirect(base_url('client/logout'));
    }
    $getUser = $CMSNT->get_row_safe("SELECT * FROM `users` WHERE `token` = ?", [$user_token]);
    // Chuyển hướng đăng nhập khi thông tin login không tồn tại
    if (!$getUser) {
        redirect(base_url('client/logout'));
    }
    // Chuyển hướng khi bị khoá tài khoản
    if ($getUser['banned'] != 0) {
        redirect(base_url('common/banned'));
    }
    // Khác thiết bị khi login thì đăng xuất
    if ($getUser['device'] != $Mobile_Detect->getUserAgent()){
        redirect(base_url('client/logout'));
    }
    // khoá tài khoản trường hợp âm tiền, tránh bug
    if ($getUser['money'] < 0) {
        $User = new users();
        $User->Banned($getUser['id'], 'Tài khoản âm tiền, ghi vấn bug');
        redirect(base_url('common/banned'));
    }
    if($CMSNT->site('status_active_member') == 1){
        if($getUser['active'] != 1){
            redirect(base_url('common/not-active'));
        }
    }
    // Validate user ID và IP trước khi update
    $user_id = validate_int($getUser['id'], 1);
    $user_ip = validate_ip(myip());
    if ($user_id !== false && $user_ip !== false) {
        $CMSNT->update('users', [
            'update_date'   => gettime(),
            'ip'            => $user_ip
        ], " `id` = ?", [$user_id]);
    }
}

 
 